<?php
if (isset($_POST['submit-uaf-settings'])){
	if (isset($_POST['uaf_disbale_editor_font_list'])){
		$uaf_disbale_editor_font_list = 1;
	} else {
		$uaf_disbale_editor_font_list = '';
	}
	
	if (isset($_POST['uaf_use_curl_uploader'])){
		$uaf_use_curl_uploader = 1;
	} else {
		$uaf_use_curl_uploader = '';
	}
	
	if (isset($_POST['uaf_use_absolute_font_path'])){
		$uaf_use_absolute_font_path = 1;
	} else {
		$uaf_use_absolute_font_path = '';
	}
	
	if (isset($_POST['uaf_use_alternative_server'])){
		$uaf_use_alternative_server = 1;
	} else {
		$uaf_use_alternative_server = '';
	}
	
	update_option('uaf_disbale_editor_font_list', $uaf_disbale_editor_font_list);
	update_option('uaf_use_curl_uploader', $uaf_use_curl_uploader);
	update_option('uaf_use_absolute_font_path', $uaf_use_absolute_font_path);	
	update_option('uaf_use_alternative_server', $uaf_use_alternative_server);	
	$settings_message = 'Settings Saved';
	
	uaf_write_css(); // Need to rewrite css for uaf_use_relative_font_path setting change 
}


add_action('admin_menu', 'uaf_create_menu');
add_action("admin_print_scripts", 'adminjslibs');
add_action("admin_print_styles", 'adminCsslibs');
add_action('wp_enqueue_scripts', 'uaf_client_css');
add_action('plugins_loaded', 'uaf_update_check');
add_action('init', 'uaf_editor_setup');
//add_action('admin_notices', 'uaf_api_notification');

if (isset($_GET['uaf_api_notification_hide']) == 1){
	update_option('uaf_api_notification_hide','yes_2');
}

/*
function uaf_api_notification(){
	if (get_option('uaf_api_notification_hide') != 'yes_2'){
		 echo '<div class="updated">
       <p style="color:#900;"><b>Use Any Font</b></p>
	   <p>
	   Premium Key that were bought before 24th Sep, 2018 will no longer work in Use Any Font 5.0. So please get your replacement key <a href="https://dineshkarki.com.np/use-any-font/api-key" target="_blank"><b>here</b></a>. You do not need to pay again. Use your old Premium Key as Discount Coupon and it will apply 100% discount. We are sorry for the inconvenience caused.</p><p>
	   <a style="display:block;text-align:right;" href="admin.php?page=uaf_settings_page&uaf_api_notification_hide=1">Hide This Message</a></p>
	   </div>';
	}
}
*/

$uaf_disbale_editor_font_list_value = get_option('uaf_disbale_editor_font_list');
if ($uaf_disbale_editor_font_list_value != 1):
	add_filter('mce_buttons_2', 'wp_editor_fontsize_filter');
	add_filter('tiny_mce_before_init', 'uaf_mce_before_init' );
endif;

function uaf_client_css() {
	$uaf_upload 	= wp_upload_dir();
	$uaf_upload_url = set_url_scheme($uaf_upload['baseurl']);
	$uaf_upload_url = $uaf_upload_url . '/useanyfont/';
	wp_register_style( 'uaf_client_css', $uaf_upload_url.'uaf.css', array(),get_option('uaf_css_updated_timestamp'));
	wp_enqueue_style( 'uaf_client_css' );
}

function adminjslibs(){
	wp_register_script('uaf_validate_js',plugins_url("use-any-font/js/jquery.validate.min.js"));		
	wp_enqueue_script('uaf_validate_js');
}

function adminCsslibs(){
	$uaf_upload 	= wp_upload_dir();
	$uaf_upload_url = set_url_scheme($uaf_upload['baseurl']);
	$uaf_upload_url = $uaf_upload_url . '/useanyfont/';
	wp_register_style('uaf-admin-style', plugins_url('use-any-font/css/uaf_admin.css'));
    wp_enqueue_style('uaf-admin-style');
	wp_register_style('uaf-font-style', $uaf_upload_url.'admin-uaf.css', array(), get_option('uaf_css_updated_timestamp'));
    wp_enqueue_style('uaf-font-style');
	add_editor_style($uaf_upload_url.'admin-uaf.css');
}
		
function uaf_create_menu() {
	add_menu_page( 'Use Any Font', 'Use Any Font', 'manage_options', 'uaf_settings_page', 'uaf_settings_page', 'dashicons-editor-textcolor');
}

function uaf_activate(){
	uaf_create_folder(); // CREATE FOLDER
	uaf_write_css(); //rewrite css when plugin is activated after update or somethingelse......
}

function uaf_settings_page() {
	include('includes/uaf_header.php');
	if ($GLOBALS['uaf_use_curl_uploader'] == 1){
		include('includes/uaf_font_upload_php.php');
	} else {
		include('includes/uaf_font_upload_js.php');	
	}
	include('includes/uaf_font_implement.php');
	include('includes/uaf_footer.php');
}


function uaf_editor_setup(){
	include('includes/uaf_editor_setup.php');
}